import javax.swing.*;
import javax.swing.tree.*;

import de.luschny.struct.bintree.BinaryTree;
import de.luschny.struct.bintree.BinaryTreeTraverse;
import de.luschny.struct.bintree.BinaryTreeGui;

/**
 * Beispiel und Test fuer die
 * Klassen BinaryTree und BinaryTreeTraverse
 * 
 * @author Peter Luschny
 * @version 1.0, 2000-12-10
 * minor modification 2001-01-04
 */

public class BinaryTreeTest
{
    /**
     * Teste deinen binren Baum!
     * @param ignore
     */

    static void main(String[] ignore)
    {   // peltuserchny // jagmosesling 
        Object A = new Character('j');
        Object B = new Character('a');
        Object C = new Character('g');
        Object D = new Character('m');
        Object E = new Character('o');
        Object F = new Character('s');
        Object G = new Character('e');
        Object H = new Character('s');
        Object I = new Character('l');
        Object K = new Character('i');
        Object L = new Character('n');
        Object M = new Character('g');

        BinaryTree tree = new BinaryTree();
        BinaryTree.Node n, nr, nl;

        tree.setRoot(A);

        n = tree.getRoot();
        tree.setLeftChild(B, n);

        nl = tree.getLeftChild(n);
        tree.setRightChild(C, n);

        nr = tree.getRightChild(n);
        tree.setLeftChild(D, nl);

        n = tree.getLeftChild(nl);
        tree.setLeftChild(E, nr);
        tree.setRightChild(F, nr);
        tree.setLeftChild(G, n);
        tree.setRightChild(H, n);

        n = tree.getRightChild(nr);
        tree.setLeftChild(I, n);
        tree.setRightChild(K, n);

        n = tree.getRightChild(n);
        tree.setLeftChild(L, n);
        tree.setRightChild(M, n);

        System.out.println("Beispiel fr binren Baum");
        System.out.println("=========================");

        // Anzahl der Knoten bestimmen
        System.out.print("Anzahl der Knoten:  ");
        System.out.println(tree.size(tree.getRoot()));

        // Baum traversieren
        BinaryTreeTraverse tour = new BinaryTreeTraverse(tree);
        System.out.print("Baum in Prordnung durchlaufen:    ");
        tour.preOrderTraverse();
        System.out.println();
        System.out.print("Baum in Inordnung durchlaufen:     ");
        tour.inOrderTraverse();
        System.out.println();
        System.out.print("Baum in Postordnung durchlaufen:   ");
        tour.postOrderTraverse();
        System.out.println();
        System.out.print("Baum in Neuordnung durchlaufen:    ");
        tour.peterOrderTraverse();
        System.out.println();

        // So einfach ist das Bearbeiten der Werte
        tour = new BinaryTreeTraverse(tree)
        {
            /**
             * Ueberschreiben der Methode visit in TreeTraverse
             */

            public void visit(Object obj)
            {
                char c = Character.toUpperCase(((Character) obj).charValue());
                System.out.print(c + " ");
            }
        };

        System.out.print("Baum zur Bearbeitung durchlaufen:  ");
        tour.preOrderTraverse();
        System.out.println();

        // Eine einfache Utility zum Visualisieren des Baumes
        BinaryTreeGui guiTree = new BinaryTreeGui(tree,"I like Java!");
        guiTree.displayBinaryTree();
        
        // Lschen und fertig..
        tree.clear();
        System.out.print("Baum gelscht ..");
        tour.postOrderTraverse();  // nichts rhrt sich, also
        System.out.println("..fertig");
    }

}

/*
 * Beispiel fr binren Baum
 * =========================
 * Anzahl der Knoten:  12
 * Baum in Prordnung durchlaufen:   p e t e r l u s c h n y
 * Baum in Inordnung durchlaufen:    e t r e p u l c s n h y
 * Baum in Postordnung durchlaufen:  e r t e u c n y h s l p
 * Baum in Neuordnung durchlaufen:   p l s h y n c u e t r e
 * Baum zur Bearbeitung durchlaufen: P E T E R L U S C H N Y
 * Baum gelscht:
 */

